/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.preferences;

import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import com.aptana.editor.php.internal.builder.preferences.ProjectDependencies;
import com.aptana.editor.php.internal.ui.preferences.FullPathWorkbenchLabelProvider;
import com.aptana.editor.php.internal.ui.preferences.LibraryLabelProvider;
import com.aptana.editor.php.internal.ui.preferences.Messages;
import com.aptana.editor.php.internal.ui.preferences.WorkspaceFolderSelectionDialog;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;

public class BuildPathEditingComposite
extends Composite {
    private TableViewer workspaceViewer;
    private TableViewer directoryViewer;
    private CheckboxTableViewer libraryViewer;
    private boolean usesCustomLibs;
    private Set<String> notusedLibraries = new HashSet<String>();
    private Button customLibsButton;
    private Button select;
    private Button deselect;
    private IProject project;
    private final PropertyPage propertyPage;

    public BuildPathEditingComposite(PropertyPage propertyPage, Composite parent, int style) {
        super(parent, style);
        Assert.isNotNull((Object)propertyPage, (String)"PropertyPage was null");
        this.propertyPage = propertyPage;
        this.project = (IProject)propertyPage.getElement().getAdapter(IProject.class);
        this.setLayout((Layout)new FillLayout());
        TabFolder fld = new TabFolder((Composite)this, 16384);
        TabItem item = new TabItem(fld, 0);
        item.setText(Messages.BuildPathEditingComposite_ProjectsTabTitle);
        this.createWorkspacePart(item);
        TabItem item1 = new TabItem(fld, 0);
        item1.setText(Messages.BuildPathEditingComposite_DirectoriesTabTitle);
        TabItem item2 = new TabItem(fld, 0);
        item2.setText(Messages.BuildPathEditingComposite_libraries);
        this.createDirectoryPart(item1);
        this.createLibraryPart(item2);
    }

    private void createLibraryPart(TabItem item) {
        TabFolder parent2 = item.getParent();
        Composite projectPart = new Composite((Composite)parent2, 0);
        projectPart.setLayout((Layout)new GridLayout(2, false));
        this.customLibsButton = new Button(projectPart, 32);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.customLibsButton.setLayoutData((Object)layoutData);
        this.customLibsButton.setText(Messages.BuildPathEditingComposite_projectSpecific);
        this.libraryViewer = CheckboxTableViewer.newCheckList((Composite)projectPart, (int)2048);
        this.libraryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        IPHPLibrary[] allLibraries = LibraryManager.getInstance().getAllLibraries();
        this.libraryViewer.setInput((Object)allLibraries);
        this.libraryViewer.setComparator(new ViewerComparator());
        final HashMap<URL, Image> images = new HashMap<URL, Image>();
        this.libraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider(images));
        Composite buttons = new Composite(projectPart, 0);
        projectPart.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image m : images.values()) {
                    m.dispose();
                }
            }
        });
        this.libraryViewer.getControl().setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        this.select = new Button(buttons, 0);
        this.select.setText(Messages.LibrariesPage_selectAll);
        this.select.setLayoutData((Object)new GridData(768));
        this.deselect = new Button(buttons, 0);
        this.deselect.setText(Messages.LibrariesPage_deselectAll);
        this.deselect.setLayoutData((Object)new GridData(768));
        buttons.setLayoutData((Object)new GridData(1040));
        this.customLibsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = BuildPathEditingComposite.this.customLibsButton.getSelection();
                BuildPathEditingComposite.this.libraryViewer.getControl().setEnabled(selection);
                BuildPathEditingComposite.this.select.setEnabled(selection);
                BuildPathEditingComposite.this.deselect.setEnabled(selection);
            }
        });
        this.select.addSelectionListener((SelectionListener)new SelectAction(true));
        this.deselect.addSelectionListener((SelectionListener)new SelectAction(false));
        item.setControl((Control)projectPart);
    }

    private void createDirectoryPart(TabItem item) {
        TabFolder parent2 = item.getParent();
        Composite projectPart = new Composite((Composite)parent2, 0);
        projectPart.setLayout((Layout)new GridLayout(2, false));
        this.directoryViewer = new TableViewer(projectPart, 2050);
        this.directoryViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }

            public String getText(Object element) {
                File fl = (File)element;
                return fl.getAbsolutePath();
            }
        });
        this.directoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.directoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        Composite buttonsComp = new Composite(projectPart, 0);
        buttonsComp.setLayoutData((Object)new GridData(1040));
        buttonsComp.setLayout((Layout)new GridLayout(1, false));
        Button add = new Button(buttonsComp, 0);
        add.setText(Messages.BuildPathEditingComposite_AddDirectory);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 0);
                dialog.setText(Messages.BuildPathEditingComposite_AddDirectoryDescription);
                String open = dialog.open();
                if (open != null) {
                    BuildPathEditingComposite.this.addWithValidation(BuildPathEditingComposite.this.directoryViewer, new File(open));
                }
            }
        });
        add.setLayoutData((Object)GridDataFactory.fillDefaults().hint(100, -1).create());
        final Button remove = new Button(buttonsComp, 0);
        remove.setText(Messages.BuildPathEditingComposite_RemoveDirectory);
        remove.setLayoutData((Object)GridDataFactory.fillDefaults().hint(100, -1).create());
        this.directoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        remove.setEnabled(false);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                IStructuredSelection sel = (IStructuredSelection)BuildPathEditingComposite.this.directoryViewer.getSelection();
                Object[] objectArray = selections = sel.toArray();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    BuildPathEditingComposite.this.directoryViewer.remove(selected);
                    ++n2;
                }
            }
        });
        this.directoryViewer.setSorter(new ViewerSorter());
        item.setControl((Control)projectPart);
    }

    private void createWorkspacePart(TabItem item) {
        TabFolder parent2 = item.getParent();
        Composite projectPart = new Composite((Composite)parent2, 0);
        item.setControl((Control)projectPart);
        projectPart.setLayout((Layout)new GridLayout(2, false));
        this.workspaceViewer = new TableViewer(projectPart, 2050);
        final FullPathWorkbenchLabelProvider workbenchLabelProvider = new FullPathWorkbenchLabelProvider(this.project);
        this.workspaceViewer.setLabelProvider((IBaseLabelProvider)workbenchLabelProvider);
        this.workspaceViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                workbenchLabelProvider.doDispose();
            }
        });
        this.workspaceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.workspaceViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsComp = new Composite(projectPart, 0);
        buttonsComp.setLayoutData((Object)new GridData(1040));
        buttonsComp.setLayout((Layout)new GridLayout(1, false));
        Button add = new Button(buttonsComp, 0);
        add.setText(Messages.BuildPathEditingComposite_AddProjectTitle);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceFolderSelectionDialog dialog = new WorkspaceFolderSelectionDialog(Display.getCurrent().getActiveShell());
                dialog.setTitle(Messages.BuildPathEditingComposite_ProjectsSelectionTitle);
                dialog.setMessage(Messages.BuildPathEditingComposite_AddProjectDesription);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                dialog.setInput(workspace);
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return !(element instanceof IResource) || !BuildPathEditingComposite.this.project.equals((Object)((IResource)element).getProject());
                    }
                });
                if (dialog.open() == 0) {
                    BuildPathEditingComposite.this.addWithValidation(BuildPathEditingComposite.this.workspaceViewer, dialog.getResult());
                }
            }
        });
        add.setLayoutData((Object)GridDataFactory.fillDefaults().hint(100, -1).create());
        final Button remove = new Button(buttonsComp, 0);
        remove.setText(Messages.BuildPathEditingComposite_RemoveProjectTitle);
        remove.setEnabled(false);
        this.workspaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BuildPathEditingComposite.this.project != null) {
                    remove.setEnabled(!event.getSelection().isEmpty() && !((IStructuredSelection)event.getSelection()).toList().contains(BuildPathEditingComposite.this.project));
                } else {
                    remove.setEnabled(!event.getSelection().isEmpty());
                }
            }
        });
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                IStructuredSelection sel = (IStructuredSelection)BuildPathEditingComposite.this.workspaceViewer.getSelection();
                Object[] objectArray = selections = sel.toArray();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    BuildPathEditingComposite.this.workspaceViewer.remove(selected);
                    ++n2;
                }
            }
        });
        remove.setLayoutData((Object)GridDataFactory.fillDefaults().hint(100, -1).create());
        this.workspaceViewer.setSorter(new ViewerSorter());
    }

    public void init(List<IResource> workspaceResources, List<File> directories) {
        if (this.project != null && !workspaceResources.contains(this.project)) {
            workspaceResources.add(0, (IResource)this.project);
        }
        this.workspaceViewer.setInput((Object)workspaceResources.toArray());
        this.directoryViewer.setInput((Object)directories.toArray());
    }

    private void addWithValidation(TableViewer tableViewer, Object item) {
        this.propertyPage.setMessage(null);
        TableItem[] tableItems = tableViewer.getTable().getItems();
        if (tableItems == null || tableItems.length == 0) {
            if (item instanceof Object[]) {
                Object[] items;
                Object[] objectArray = items = (Object[])item;
                if (items.length != 0) {
                    Object obj = objectArray[0];
                    tableViewer.add(obj);
                    return;
                }
            } else if (item != null) {
                tableViewer.add(item);
                return;
            }
        }
        ArrayList<Object> toAdd = new ArrayList<Object>();
        boolean hasAlreadyIncludedPaths = false;
        if (item instanceof File) {
            File directoryAdded = (File)item;
            boolean shouldAdd = true;
            TableItem[] tableItemArray = tableItems;
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                File existinsDirectory;
                TableItem tableItem = tableItemArray[n2];
                Object data = tableItem.getData();
                if (data instanceof File && ((existinsDirectory = (File)data).equals(directoryAdded) || directoryAdded.getAbsolutePath().startsWith(existinsDirectory.getAbsolutePath()))) {
                    hasAlreadyIncludedPaths = true;
                    shouldAdd = false;
                    break;
                }
                ++n2;
            }
            if (shouldAdd) {
                toAdd.add(directoryAdded);
            }
        } else if (item instanceof Object[]) {
            Object[] elements;
            Object[] objectArray = elements = (Object[])item;
            int n = elements.length;
            int n3 = 0;
            while (n3 < n) {
                Object element = objectArray[n3];
                boolean shouldAdd = true;
                TableItem[] tableItemArray = tableItems;
                int n4 = tableItems.length;
                int n5 = 0;
                while (n5 < n4) {
                    TableItem tableItem = tableItemArray[n5];
                    if (element instanceof IResource && tableItem.getData() instanceof IResource) {
                        IResource resource = (IResource)element;
                        IResource resourceInTable = (IResource)tableItem.getData();
                        if (resourceInTable.getFullPath().isPrefixOf(resource.getFullPath())) {
                            hasAlreadyIncludedPaths = true;
                            shouldAdd = false;
                            break;
                        }
                    }
                    ++n5;
                }
                if (shouldAdd) {
                    toAdd.add(element);
                }
                ++n3;
            }
        }
        tableViewer.add(toAdd.toArray());
        if (hasAlreadyIncludedPaths) {
            this.propertyPage.setMessage(Messages.BuildPathEditingComposite_selectionIncludedNotice, 1);
            UIJob job = new UIJob("Build-Path::Remove message"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (BuildPathEditingComposite.this.propertyPage != null && !BuildPathEditingComposite.this.propertyPage.getControl().isDisposed()) {
                        BuildPathEditingComposite.this.propertyPage.setMessage(null);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule(4000L);
        }
    }

    public void fillResult(List<IResource> workspaceResources, List<File> fileList) {
        TableItem i;
        TableItem[] items;
        TableItem[] tableItemArray = items = this.workspaceViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            i = tableItemArray[n2];
            IResource resource = (IResource)i.getData();
            if (resource != this.project) {
                workspaceResources.add(resource);
            }
            ++n2;
        }
        tableItemArray = items = this.directoryViewer.getTable().getItems();
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            i = tableItemArray[n2];
            fileList.add((File)i.getData());
            ++n2;
        }
    }

    public void init(ProjectDependencies buildPath) {
        this.init(buildPath.getWorkspaceResources(), buildPath.getDirectories());
        this.usesCustomLibs = buildPath.isUsesCustomLibs();
        List<String> notUsedLibrariesIds = buildPath.getNotUsedLibrariesIds();
        this.notusedLibraries = new HashSet<String>(notUsedLibrariesIds);
        this.customLibsButton.setSelection(this.usesCustomLibs);
        IPHPLibrary[] iPHPLibraryArray = LibraryManager.getInstance().getAllLibraries();
        int n = iPHPLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            if (!this.notusedLibraries.contains(l.getId())) {
                this.libraryViewer.setChecked((Object)l, true);
            }
            ++n2;
        }
        this.libraryViewer.getControl().setEnabled(this.usesCustomLibs);
        this.select.setEnabled(this.usesCustomLibs);
        this.deselect.setEnabled(this.usesCustomLibs);
    }

    public void fillResult(ProjectDependencies bp) {
        ArrayList<IResource> ps = new ArrayList<IResource>();
        ArrayList<File> fs = new ArrayList<File>();
        this.fillResult(ps, fs);
        bp.set(ps, fs);
        bp.setUsesCustomLibs(this.customLibsButton.getSelection());
        ArrayList<String> notUsed = new ArrayList<String>();
        IPHPLibrary[] iPHPLibraryArray = LibraryManager.getInstance().getAllLibraries();
        int n = iPHPLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            if (!this.libraryViewer.getChecked((Object)l)) {
                notUsed.add(l.getId());
            }
            ++n2;
        }
        bp.setNotUsedLibrariesIds(notUsed);
    }

    private final class SelectAction
    implements SelectionListener {
        boolean select;

        private SelectAction(boolean doSelect) {
            this.select = doSelect;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            BuildPathEditingComposite.this.libraryViewer.setAllChecked(this.select);
        }
    }
}

